<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Istri;
use App\Models\Suami;
use App\Models\Riwayat_kesehatan;
use App\Models\Riwayat_kehamilan;
use App\Models\Kehamilan_sekarang;
use App\Models\User_navigasi;
use Auth;
use Illuminate\Http\Request;
use Validator;

use Illuminate\Support\Facades\DB;

class AfrikotController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function navigasiUtama()
    {
        
        if (Auth::guest()) {
            //is a Laravel guest so redirect
            return redirect('pendahuluan');
           }
        $kon_id = Auth::user()->id;
        $navDatadiri = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 1 )
        ->count();
        $navRiwayatKesehatan = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 2 )
        ->count();
        $navRiwayatKehamilan = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 3 )
        ->count();
        $navKehamilanSekarang = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 4 )
        ->count();
        $cekHasil = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 5 )
        ->count();
        
        return view('navigasiUtama', compact('navDatadiri', 'navRiwayatKesehatan', 'navRiwayatKehamilan', 'navKehamilanSekarang', 'cekHasil'));
    }

    public function dataDiri()
    {
        
        if (Auth::guest()) {
            //is a Laravel guest so redirect
            return redirect('pendahuluan');
           }
        $kon_id = Auth::user()->id;

        $dataIstri = Istri::where('istris.id_user','=', $kon_id )
        ->count();

        $dataSuami = Suami::where('suamis.id_user','=', $kon_id )
        ->count();

        $userNavigasi = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 1 )
        ->count();

        return view('dataDiri', compact('dataIstri', 'dataSuami', 'userNavigasi'));
    }

    public function riwayatKesehatan()
    {
        
        if (Auth::guest()) {
            //is a Laravel guest so redirect
            return redirect('pendahuluan');
           }
        $kon_id = Auth::user()->id;

        $dataRiwayatKesehatan = Riwayat_kesehatan::where('riwayat_kesehatans.id_user','=', $kon_id )
        ->count();

        $userNavigasi = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 2 )
        ->count();

        return view('riwayatKesehatan', compact('dataRiwayatKesehatan', 'userNavigasi'));
    }

    public function riwayatKehamilan()
    {
        
        if (Auth::guest()) {
            //is a Laravel guest so redirect
            return redirect('pendahuluan');
           }
        $kon_id = Auth::user()->id;

        $dataRiwayatKehamilan = Riwayat_kehamilan::where('riwayat_kehamilans.id_user','=', $kon_id )
        ->count();

        $userNavigasi = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 3 )
        ->count();

        return view('riwayatKehamilan', compact('dataRiwayatKehamilan', 'userNavigasi'));
    }

    public function kehamilanSekarang()
    {
        
        if (Auth::guest()) {
            //is a Laravel guest so redirect
            return redirect('pendahuluan');
           }
        $kon_id = Auth::user()->id;

        $dataKehamilanSekarang = Kehamilan_sekarang::where('kehamilan_sekarangs.id_user','=', $kon_id )
        ->count();

        $userNavigasi = User_navigasi::where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 4 )
        ->count();

        return view('kehamilanSekarang', compact('dataKehamilanSekarang', 'userNavigasi'));
    }

    public function listSurvey()
    {
        
        if (Auth::guest()) {
            //is a Laravel guest so redirect
            return redirect('pendahuluan');
           }
        $kon_id = Auth::user()->id;

        $nutrisiIbu = DB::table('nutrisi_ibu_hamil')->where('nutrisi_ibu_hamil.id_user','=', $kon_id )
        ->count();

        $bukuKIA = DB::table('buku_kia')->where('buku_kia.id_user','=', $kon_id )
        ->count();

        $anemiaKehamilan = DB::table('anemia_kehamilan')->where('anemia_kehamilan.id_user','=', $kon_id )
        ->count();

        $surveyCompleted = DB::table('user_navigasis')
        ->where('user_navigasis.id_user','=', $kon_id )
        ->where('user_navigasis.id_navigasi','=', 5 )
        ->count();

        return view('listSurvey', compact('nutrisiIbu', 'bukuKIA', 'anemiaKehamilan', 'surveyCompleted'));
    }

    public function interpretasi()
    {
        
        if (Auth::guest()) {
            //is a Laravel guest so redirect
            return redirect('pendahuluan');
           }
        $kon_id = Auth::user()->id;

        $interpretasi = DB::table('users')
        ->leftjoin('istris', 'istris.id_user', '=' ,'users.id')
        ->leftjoin('suamis', 'suamis.id_user', '=' ,'users.id')
        ->leftjoin('kehamilan_sekarangs', 'kehamilan_sekarangs.id_user', '=' ,'users.id')
        ->leftjoin('riwayat_kehamilans', 'riwayat_kehamilans.id_user', '=' ,'users.id')
        ->leftjoin('riwayat_kesehatans', 'riwayat_kesehatans.id_user', '=' ,'users.id')
        ->where('users.id','=', $kon_id )
        ->first();;

        return view('interpretasi', compact('interpretasi'));
    }

    public function store(Request $request)
    {  
 
        $validator = Validator::make($request->all(), [
            'nama_istri' => 'required',
        
            'suku_istri' => 'required',
            'tgl_lahir_istri' => 'required',
            'usia_istri' => 'required',
            'no_hp_istri' => 'required',
            'pekerjaan_istri' => 'required',
            'gaya_kerja_istri' => 'required',
            'pendidikan_istri' => 'required',
            'status_tempat_tinggal_istri' => 'required',
            'pendapatan_istri' => 'required',
            'jamkes_istri' => 'required',
            'jenis_jamkes_istri' => 'required',
            'usia_nikah_istri' => 'required',
            'usia_hamil' => 'required',
            'tb_istri' => 'required',
            'bb_belum_hamil' => 'required',
            'bb_saat_hamil' => 'required',
            'lingkar_lengan' => 'required',
        	'status_kepala_keluarga_istri' => 'required',

        ]);

        if ($validator->passes()) {
        
        $id_user = $request->input('id_user');        
        $nama = $request->input('nama_istri');
        
        $suku = $request->input('suku_istri');
        $tgl_lahir = $request->input('tgl_lahir_istri');
        $usia = $request->input('usia_istri');
        $alamat = $request->input('alamat_istri');
        $no_hp = $request->input('no_hp_istri');
        $pekerjaan = $request->input('pekerjaan_istri');
        $gaya_kerja = $request->input('gaya_kerja_istri');
        $pendidikan = $request->input('pendidikan_istri');
        $status_tempat_tinggal = $request->input('status_tempat_tinggal_istri');
        $pendapatan = $request->input('pendapatan_istri');
        $jamkes = $request->input('jamkes_istri');
        $jenis_jamkes = $request->input('jenis_jamkes_istri');
        $usia_nikah = $request->input('usia_nikah_istri');
        $usia_hamil = $request->input('usia_hamil');
        $tb = $request->input('tb_istri');
        $tb_satuan_meter = $tb/100;
        $bb_belum_hamil = $request->input('bb_belum_hamil');
        $imt = $bb_belum_hamil/($tb_satuan_meter*$tb_satuan_meter);
        $bb_saat_hamil = $request->input('bb_saat_hamil');
        $lingkar_lengan = $request->input('lingkar_lengan');
        $status_kepala_keluarga = $request->input('status_kepala_keluarga_istri');
        


        //insert into table        
        $dataIstri=array(
        	'id_user'=>$id_user,
        	'nama_istri'=>$nama,
        
        	'suku_istri'=>$suku,
        	'tgl_lahir_istri'=>$tgl_lahir,
        	'usia_istri'=>$usia,
        	'alamat_istri'=>$alamat,
        	'no_hp_istri'=>$no_hp,
        	'pekerjaan_istri'=>$pekerjaan,
        	'gaya_kerja_istri'=>$gaya_kerja,
        	'pendidikan_istri'=>$pendidikan,
        	'status_tempat_tinggal_istri'=>$status_tempat_tinggal,
        	'pendapatan_istri'=>$pendapatan,
        	'jamkes_istri'=>$jamkes,
        	'jenis_jamkes_istri'=>$jenis_jamkes,
        	'usia_nikah_istri'=>$usia_nikah,
        	'usia_hamil'=>$usia_hamil,
        	'tb_istri'=>$tb,
        	'bb_belum_hamil'=>$bb_belum_hamil, 
        	'imt_pra_hamil'=>$imt,
        	'bb_saat_hamil'=>$bb_saat_hamil,
        	'lingkar_lengan'=>$lingkar_lengan,
        	'status_kepala_keluarga_istri'=>$status_kepala_keluarga);
            
        
        //Insert into table 
         DB::table('istris')->insert($dataIstri);   
                                  
        return response()->json(['success'=>'Data submit successfully.']);
        }
    
    return response()->json(['errors'=>$validator->errors()]);
    }
   
    public function suamiStore(Request $request)
    {  
 		$validator = Validator::make($request->all(), [
            'nama_suami' => 'required',
            'suku_suami' => 'required',
            'tgl_lahir_suami' => 'required',
            'usia_suami' => 'required',
            'alamat_suami' => 'required',
            'no_hp_suami' => 'required',
            'pekerjaan_suami' => 'required',
            'pendidikan_suami' => 'required',
            'status_tempat_tinggal_suami' => 'required',
            'pendapatan_suami' => 'required',
            'jamkes_suami' => 'required',
            'jenis_jamkes_suami' => 'required',
            'usia_nikah_suami' => 'required',
            'tb_suami' => 'required',
            'bb_suami' => 'required',
            'status_kepala_keluarga_suami' => 'required',
        ]);
    
    
        if ($validator->passes()) {
        
        $id_user = $request->input('id_user');        
        $nama = $request->input('nama_suami');
        $suku = $request->input('suku_suami');
        $tgl_lahir = $request->input('tgl_lahir_suami');
        $usia = $request->input('usia_suami');
        $alamat = $request->input('alamat_suami');
        $no_hp = $request->input('no_hp_suami');
        $pekerjaan = $request->input('pekerjaan_suami');
        $pendidikan = $request->input('pendidikan_suami');
        $status_tempat_tinggal = $request->input('status_tempat_tinggal_suami');
        $pendapatan = $request->input('pendapatan_suami');
        $jamkes = $request->input('jamkes_suami');
        $jenis_jamkes = $request->input('jenis_jamkes_suami');
        $usia_nikah = $request->input('usia_nikah_suami');
        $tb = $request->input('tb_suami');
        $bb = $request->input('bb_suami');
        $status_kepala_keluarga = $request->input('status_kepala_keluarga_suami');


        //insert into akademik         
        $dataSuami=array(
        	'id_user'=>$id_user,
        	'nama_suami'=>$nama,
        	'suku_suami'=>$suku,
        	'tgl_lahir_suami'=>$tgl_lahir,
        	'usia_suami'=>$usia,
        	'alamat_suami'=>$alamat,
        	'no_hp_suami'=>$no_hp,
        	'pekerjaan_suami'=>$pekerjaan,
        	'pendidikan_suami'=>$pendidikan,
        	'status_tempat_tinggal_suami'=>$status_tempat_tinggal,
        	'pendapatan_suami'=>$pendapatan,
        	'jamkes_suami'=>$jamkes,
        	'jenis_jamkes_suami'=>$jenis_jamkes,
        	'usia_nikah_suami'=>$usia_nikah,
        	'tb_suami'=>$tb,
        	'bb_suami'=>$bb,
        	'status_kepala_keluarga_suami'=>$status_kepala_keluarga
        );
        //Insert into table 
         DB::table('suamis')->insert($dataSuami);   
                                  
        return response()->json(['success'=>'Data submit successfully.']); 
    }
    return response()->json(['errors'=>$validator->errors()]);
    }

    public function kesehatanStore(Request $request){
    
    $validator = Validator::make($request->all(), [
            'riwayat_haid' => 'required',
            'konsumsi_obat' => 'required',
        ]);

        $penyakit_bumil =  $request->input('q1',[]);
        $penyakitlain = $request->input('name2');

        $id_user = $request->input('id_user');
        $haid = $request->input('riwayat_haid');
        $obat = $request->input('konsumsi_obat');
        
        $jenis_obat = $request->input('janis_obat',[]);
        $obatlain = $request->input('name3');

        $penyakit = [];

        foreach ($penyakit_bumil as $rows_penyakit => $key) {
            $penyakit[] = [
                "id_user" => $id_user,
                "penyakit_bumil" => $penyakit_bumil[$rows_penyakit]
            ];
        }
        $penyakitlain2=array('id_user'=>$id_user,'penyakit_bumil'=>$penyakitlain);

        if ( $penyakitlain == ""){
            DB::table('penyakit_bumil')->insert($penyakit);
        }else{
            DB::table('penyakit_bumil')->insert($penyakit);
            DB::table('penyakit_bumil')->insert($penyakitlain2);
        }
        
        

        $jenis = [];

        foreach ($jenis_obat as $rows_jenis => $key) {
            $jenis[] = [
                "id_user" => $id_user,
                "jenis_obat" => $jenis_obat[$rows_jenis]
            ];
        }
        
        $obatlain2=array('id_user'=>$id_user,'jenis_obat'=>$obatlain);
        if ( $obatlain == ""){
            DB::table('jenis_obat')->insert($jenis);
        } else{
            DB::table('jenis_obat')->insert($jenis);
            DB::table('jenis_obat')->insert($obatlain2);
        }
    
    if ($validator->passes()) {
    
    	$riwayatkesehatan=array(
        	'id_user'=>$id_user,
        	'riwayat_haid'=>$haid, 
        	'konsumsi_obat'=>$obat
        );
        DB::table('riwayat_kesehatans')->insert($riwayatkesehatan);

        return response()->json(['success'=>'Data submit successfully.']); 
    }
    
    return response()->json(['error'=>$validator->errors()]);

    }

    public function kehamilanStore(Request $request){

        $validator = Validator::make($request->all(), [
            'q1' => 'required',
            'q2' => 'required',
            'q3' => 'required',
            'q4' => 'required',
            'q5' => 'required',
            'q6' => 'required',
            'q7' => 'required',
            'q9' => 'required',
            'q11' => 'required',
            'q12' => 'required',
            'q13' => 'required',
            'q14' => 'required',
            'q15' => 'required',
            'q16' => 'required',
            'q17' => 'required',
            'q18' => 'required',
            'q19' => 'required',
            'q20' => 'required',
            'q21' => 'required',

        ]);

        if ($validator->passes()) {


        $id_user = $request->input('id_user');
        $status_kehamilan = $request->input('q1');
        $riwayat_keguguran = $request->input('q2');
        $jumlah_keguguran = $request->input('q3');
        $riwayat_bayi_meniggal = $request->input('q4');
        $jumlah_bayi_meninggal = $request->input('q5');
        $jumlah_anak = $request->input('q6');
        $jarak_lahir = $request->input('q7');
        $lahir_cacat = $request->input('q9');
        $lahir_kelainan = $request->input('q10');
        $lahir_tidak_menangis = $request->input('q11');
        $lahir_bb_kecil = $request->input('q12');
        $riwayat_dm = $request->input('q13');
        $riwayat_hipertensi = $request->input('q14');
        $riwayat_dm_sebelumnya = $request->input('q15');
        $riwayat_hipertensi_sebelumnya = $request->input('q16');
        $riwayat_bengkak = $request->input('q17');
        $riwayat_perdarahan = $request->input('q18');
        $riwayat_anak_kembar = $request->input('q19');
        $kembar_berapa = $request->input('q20');
        $kesulitan_persalinan = $request->input('q21');

        $riwayatkehamilan=array(
            'id_user'=>$id_user,
            'status_kehamilan'=>$status_kehamilan, 
            'riwayat_keguguran'=>$riwayat_keguguran, 
            'jumlah_keguguran'=>$jumlah_keguguran, 
            'riwayat_bayi_meniggal'=>$riwayat_bayi_meniggal, 
            'jumlah_bayi_meninggal'=>$jumlah_bayi_meninggal, 
            'jumlah_anak'=>$jumlah_anak, 
            'jarak_lahir'=>$jarak_lahir, 
            'lahir_cacat'=>$lahir_cacat, 
            'lahir_kelainan'=>$lahir_kelainan, 
            'lahir_tidak_menangis'=>$lahir_tidak_menangis, 
            'lahir_bb_kecil'=>$lahir_bb_kecil, 
            'riwayat_dm'=>$riwayat_dm, 
            'riwayat_hipertensi'=>$riwayat_hipertensi, 
            'riwayat_dm_sebelumnya'=>$riwayat_dm_sebelumnya, 
            'riwayat_hipertensi_sebelumnya'=>$riwayat_hipertensi_sebelumnya, 
            'riwayat_bengkak'=>$riwayat_bengkak, 
            'riwayat_perdarahan'=>$riwayat_perdarahan, 
            'riwayat_anak_kembar'=>$riwayat_anak_kembar, 
            'kembar_berapa'=>$kembar_berapa, 
            'kesulitan_persalinan'=>$kesulitan_persalinan);
        DB::table('riwayat_kehamilans')->insert($riwayatkehamilan);


        $proses_melahirkan = $request->input('q8',[]);       
        $proses = [];
        foreach ($proses_melahirkan as $rows_proses => $key) {
            $proses[] = [
                "id_user" => $id_user,
                "proses_melahirkan" => $proses_melahirkan[$rows_proses]
            ];
        }
        DB::table('proses_melahirkan')->insert($proses);

        $jenis_kesulitan = $request->input('q22',[]);
        $kesulitanlain = $request->input('name3');
        $jenis_kesulitan2=array('id_user'=>$id_user,'jenis_kesulitan'=>$kesulitanlain);

        $proses = [];
        foreach ($jenis_kesulitan as $rows_kesulitan => $key) {
            $proses[] = [
                "id_user" => $id_user,
                "jenis_kesulitan" => $jenis_kesulitan[$rows_kesulitan]
            ];
        }
        if ( $kesulitanlain == ""){
            DB::table('jenis_kesulitan')->insert($proses);
        } else{
            DB::table('jenis_kesulitan')->insert($proses);
            DB::table('jenis_kesulitan')->insert($kesulitanlain2);
        }

        return response()->json(['success'=>'Data submit successfully.']); 
    }

    return response()->json(['error'=>$validator->errors()]);

    }

    public function kehamilanSekarangStore(Request $request){

        $validator = Validator::make($request->all(), [
            
            'q1' => 'required',
            'q2a' => 'required',
            'q2b' => 'required',
            'q2c' => 'required',
            'q3' => 'required',
            'q4' => 'required',
            'q5' => 'required',
            'q6' => 'required',
            'q8' => 'required',
            'q11' => 'required',
            'q12' => 'required',
            'q13' => 'required',
            'q14' => 'required',
            'q16' => 'required',
            'q18' => 'required',
            'q19' => 'required',
            'q21' => 'required',
            'q22' => 'required',
            'q23' => 'required',
            'q26' => 'required',
            'q27' => 'required',
            'q28' => 'required',
            'q29' => 'required',
            'q30' => 'required',
            'q32' => 'required',
            

        ]);

        if ($validator->passes()) {


        $id_user = $request->input('id_user');
        $buku_hamil = $request->input('q1');
        //$haid_terakhir = $request->input('q2');
        $tgl_haid_terakhir = $request->input('q2a');
        $bln_haid_terakhir = $request->input('q2b');
        $thn_haid_terakhir = $request->input('q2c');
        $usia_kehamilan = $request->input('q3');
        $kehamilan_keberapa = $request->input('q4');
        $jenis_kehamilan = $request->input('q5');
        $perdarahan = $request->input('q6');
        $waktu_perdarahan = $request->input('q7');
        $jumlah_periksa_kehamilan = $request->input('q8');
        $usia_periksa_kehamilan = $request->input('q9');
        $posisi_bayi = $request->input('q11');
        $bb_bayi = $request->input('q12');
        $detak_jantung_bayi = $request->input('q13');
        $letak_placenta = $request->input('q14');
        $tetanus = $request->input('q16');
        $tekanan_darah = $request->input('q17a');
        $diastolik = $request->input('q17b');
        $kondisi_yang_dirasa = $request->input('q18');
        $kejang = $request->input('q19');
        $waktu_kejang = $request->input('q20');
        $pemeriksaan_kencing = $request->input('q21');
        $nilai_pemeriksaan_kencing = $request->input('q22');
        $pemeriksaan_hemoglobin = $request->input('q23');
        $kadar_hemoglobin = $request->input('q24');
        $waktu_periksa_hemoglobin = $request->input('q25');
        
        $keluhan = $request->input('q26');
        $kelopak_mata = $request->input('q27');
        $golongan_darah = $request->input('q28');
        $rhesus = $request->input('q29');
        $konsumsi_tablet_besi = $request->input('q30');
        $waktu_konsumsi_tablet_besi = $request->input('q31');
        $jumlah_konsumsi_tablet_besi = $request->input('q32');
        

        $kehamilan_sekarang=array(
            'id_user'=>$id_user,
            'buku_hamil'=>$buku_hamil, 
            'tgl_haid_terakhir'=>$tgl_haid_terakhir,
            'bln_haid_terakhir'=>$bln_haid_terakhir,
            'thn_haid_terakhir'=>$thn_haid_terakhir, 
            'usia_kehamilan'=>$usia_kehamilan, 
            'kehamilan_keberapa'=>$kehamilan_keberapa, 
            'jenis_kehamilan'=>$jenis_kehamilan, 
            'perdarahan'=>$perdarahan, 
            'waktu_perdarahan'=>$waktu_perdarahan, 
            'jumlah_periksa_kehamilan'=>$jumlah_periksa_kehamilan, 
            'usia_periksa_kehamilan'=>$usia_periksa_kehamilan,
            'posisi_bayi'=>$posisi_bayi, 
            'bb_bayi'=>$bb_bayi, 
            'detak_jantung_bayi'=>$detak_jantung_bayi, 
            'letak_placenta'=>$letak_placenta, 
            'tetanus'=>$tetanus, 
            'tekanan_darah'=>$tekanan_darah,
            'diastolik'=>$diastolik,  
            'kondisi_yang_dirasa'=>$kondisi_yang_dirasa, 
            'kejang'=>$kejang, 
            'waktu_kejang'=>$waktu_kejang,
            'pemeriksaan_kencing'=>$pemeriksaan_kencing, 
            'nilai_pemeriksaan_kencing'=>$nilai_pemeriksaan_kencing,
            'pemeriksaan_hemoglobin'=>$pemeriksaan_hemoglobin,
            'kadar_hemoglobin'=>$kadar_hemoglobin,
            'waktu_periksa_hemoglobin'=>$waktu_periksa_hemoglobin,
            
            'keluhan'=>$keluhan,
            'kelopak_mata'=>$kelopak_mata,
            'golongan_darah'=>$golongan_darah,
            'rhesus'=>$rhesus,
            'konsumsi_tablet_besi'=>$konsumsi_tablet_besi,
            'waktu_konsumsi_tablet_besi'=>$waktu_konsumsi_tablet_besi,
            'jumlah_konsumsi_tablet_besi'=>$jumlah_konsumsi_tablet_besi,
        );
        DB::table('kehamilan_sekarangs')->insert($kehamilan_sekarang);


        $tempat_pemeriksaan = $request->input('q10',[]);       
        $tempat = [];
        foreach ($tempat_pemeriksaan as $rows_tempat => $key) {
            $tempat[] = [
                "id_user" => $id_user,
                "tempat_pemeriksaan" => $tempat_pemeriksaan[$rows_tempat]
            ];
        }
        DB::table('tempat_pemeriksaan')->insert($tempat);

        $jenis_pemeriksaan = $request->input('q15',[]);
        $pemeriksaanlain = $request->input('name3');
        $jenis_pemeriksaan2=array('id_user'=>$id_user,'jenis_pemeriksaan'=>$pemeriksaanlain);

        $jenis = [];
        foreach ($jenis_pemeriksaan as $rows_pemeriksaan => $key) {
            $jenis[] = [
                "id_user" => $id_user,
                "jenis_pemeriksaan" => $jenis_pemeriksaan[$rows_pemeriksaan]
            ];
        }
        if ( $pemeriksaanlain == ""){
            DB::table('jenis_pemeriksaan')->insert($jenis);
        } else{
            DB::table('jenis_pemeriksaan')->insert($jenis);
            DB::table('jenis_pemeriksaan')->insert($jenis_pemeriksaan2);
        }

        return response()->json(['success'=>'Data submit successfully.']); 
    }

    return response()->json(['error'=>$validator->errors()]);

    }

    public function nutrisiStore(Request $request){

        $validator = Validator::make($request->all(), [
            
            'q1' => 'required',
            'q2' => 'required',
            'q3' => 'required',
            'q4' => 'required',
            'q5' => 'required',
            'q6' => 'required',
            'q8' => 'required',
            'q10' => 'required',
            'q11' => 'required',
            'q12' => 'required',
            'q13' => 'required',
            'q14' => 'required',
            'q16' => 'required',
            'q17' => 'required',
            'q19' => 'required',
            'q20' => 'required',
            'q21' => 'required',
            'q23' => 'required',
            'q25' => 'required',
            'q27' => 'required',
            

        ]);

        if ($validator->passes()) {


        $id_user = $request->input('id_user');
        $jumlah_makan_sehari = $request->input('q1');
        $minum_teh_sehari = $request->input('q2');
        $jenis_teh = $request->input('q3');
        $minum_kopi_sehari = $request->input('q4');
        $minum_susu_sehari = $request->input('q5');
        $konsumsi_buah_seminggu = $request->input('q6');
        $jenis_buah = $request->input('q7');
        $konsumsi_sayur_seminggu = $request->input('q8');
        $jenis_sayur = $request->input('q9');
        $porsi_makan = $request->input('q10');
        $jumlah_jam_tidur_siang = $request->input('q11');
        $jumlah_jam_tidur_malam = $request->input('q12');
        $status_merokok_sebelum_hamil = $request->input('q13');
        $status_merokok_selama_hamil = $request->input('q14');
        $jumlah_merokok_sehari_istri = $request->input('q15');
        $jenis_rokok_istri = $request->input('q16');
        $status_perokok_suami = $request->input('q17');
        $jumlah_merokok_sehari_suami = $request->input('q18');
        $jenis_rokok_suami = $request->input('q19');
        $intensitas_suami_merokok_dekat_ibu = $request->input('q20');
        $minum_minuman_bersoda = $request->input('q21');
        $jumlah_minum_bersoda_perhari = $request->input('q22');
        $minum_jamu = $request->input('q23');
        $jenis_jamu = $request->input('q24');
        $minum_obat_tanpa_resep_sebelum_hamil = $request->input('q25');        
        $jenis_obat_sebelum_hamil = $request->input('q26');
        $minum_obat_tanpa_resep_selama_hamil = $request->input('q27');
        $jenis_obat_selama_hamil = $request->input('q28');
        

        $nutrisiIbu=array(
            'id_user'=>$id_user,
            'jumlah_makan_sehari'=>$jumlah_makan_sehari, 
            'minum_teh_sehari'=>$minum_teh_sehari, 
            'jenis_teh'=>$jenis_teh, 
            'minum_kopi_sehari'=>$minum_kopi_sehari, 
            'minum_susu_sehari'=>$minum_susu_sehari, 
            'konsumsi_buah_seminggu'=>$konsumsi_buah_seminggu, 
            'jenis_buah'=>$jenis_buah, 
            'konsumsi_sayur_seminggu'=>$konsumsi_sayur_seminggu, 
            'jenis_sayur'=>$jenis_sayur,
            'porsi_makan'=>$porsi_makan, 
            'jumlah_jam_tidur_siang'=>$jumlah_jam_tidur_siang, 
            'jumlah_jam_tidur_malam'=>$jumlah_jam_tidur_malam, 
            'status_merokok_sebelum_hamil'=>$status_merokok_sebelum_hamil, 
            'status_merokok_selama_hamil'=>$status_merokok_selama_hamil, 
            'jumlah_merokok_sehari_istri'=>$jumlah_merokok_sehari_istri, 
            'jenis_rokok_istri'=>$jenis_rokok_istri, 
            'status_perokok_suami'=>$status_perokok_suami, 
            'jumlah_merokok_sehari_suami'=>$jumlah_merokok_sehari_suami,
            'jenis_rokok_suami'=>$jenis_rokok_suami, 
            'intensitas_suami_merokok_dekat_ibu'=>$intensitas_suami_merokok_dekat_ibu,
            'minum_minuman_bersoda'=>$minum_minuman_bersoda,
            'jumlah_minum_bersoda_perhari'=>$jumlah_minum_bersoda_perhari,
            'minum_jamu'=>$minum_jamu,            
            'minum_obat_tanpa_resep_sebelum_hamil'=>$minum_obat_tanpa_resep_sebelum_hamil,
            'jenis_obat_sebelum_hamil'=>$jenis_obat_sebelum_hamil,
            'minum_obat_tanpa_resep_selama_hamil'=>$minum_obat_tanpa_resep_selama_hamil,
            'jenis_obat_selama_hamil'=>$jenis_obat_selama_hamil,);
        DB::table('nutrisi_ibu_hamil')->insert($nutrisiIbu);

        return response()->json(['success'=>'Data submit successfully.']); 
    }

    return response()->json(['error'=>$validator->errors()]);

    }

    public function bukuKiaStore(Request $request){

        $validator = Validator::make($request->all(), [
            
            'p1' => 'required',
            'p2' => 'required',
            'p3' => 'required',
            'p4' => 'required',
            'p5' => 'required',
            'p6' => 'required',
            'p7' => 'required',
            'p8' => 'required',
            'p9' => 'required',
            'p10' => 'required',
            'p11' => 'required',
            'p12' => 'required',
            'p13' => 'required',
            'p14' => 'required',
            'p15' => 'required',
            'p16' => 'required',
            'p17' => 'required',
            'p18' => 'required',          

        ]);

        if ($validator->passes()) {


        $id_user = $request->input('id_user');
        $membaca_buku_kia = $request->input('p1');
        $paham_isi_buku_kia = $request->input('p2');
        $tanya_isi_buku_kia = $request->input('p3');
        $penyebab_tidak_tanya = $request->input('p4');
        $jumlah_pemeriksaan_kehamilan = $request->input('p5');
        $penjelasan_aktivitas_dalam_buku = $request->input('p6');
        $keluar_air_ketuban = $request->input('p7');
        $keluar_darah = $request->input('p8');
        $sakit_kepala_hebat = $request->input('p9');
        $pandangan_kabur = $request->input('p10');
        $kejang = $request->input('p11');
        $tanda_awal_perut_mulas = $request->input('p12');
        $tanda_awal_keluar_lendir = $request->input('p13');
        $tahu_taksiran_kelahiran = $request->input('p14');
        $tahu_golongan_darah_sama = $request->input('p15');
        $menetapkan_tempat_kelahiran = $request->input('p16');
        $persiapan_ktp_kk = $request->input('p17');
        $kondisi_tabungan = $request->input('p18');

        $bukuKia=array(
            'id_user'=>$id_user,
            'membaca_buku_kia'=>$membaca_buku_kia, 
            'paham_isi_buku_kia'=>$paham_isi_buku_kia, 
            'tanya_isi_buku_kia'=>$tanya_isi_buku_kia, 
            'penyebab_tidak_tanya'=>$penyebab_tidak_tanya, 
            'jumlah_pemeriksaan_kehamilan'=>$jumlah_pemeriksaan_kehamilan, 
            'penjelasan_aktivitas_dalam_buku'=>$penjelasan_aktivitas_dalam_buku, 
            'keluar_air_ketuban'=>$keluar_air_ketuban, 
            'keluar_darah'=>$keluar_darah, 
            'sakit_kepala_hebat'=>$sakit_kepala_hebat,
            'pandangan_kabur'=>$pandangan_kabur, 
            'kejang'=>$kejang, 
            'tanda_awal_perut_mulas'=>$tanda_awal_perut_mulas, 
            'tanda_awal_keluar_lendir'=>$tanda_awal_keluar_lendir, 
            'tahu_taksiran_kelahiran'=>$tahu_taksiran_kelahiran, 
            'tahu_golongan_darah_sama'=>$tahu_golongan_darah_sama, 
            'menetapkan_tempat_kelahiran'=>$menetapkan_tempat_kelahiran, 
            'persiapan_ktp_kk'=>$persiapan_ktp_kk, 
            'kondisi_tabungan'=>$kondisi_tabungan,
        );
        DB::table('buku_kia')->insert($bukuKia);

        return response()->json(['success'=>'Data submit successfully.']); 
    }

    return response()->json(['error'=>$validator->errors()]);

    }

    public function anemiaKehamilanStore(Request $request){

        $validator = Validator::make($request->all(), [
            
            'j1' => 'required',
            'j2' => 'required',
            'j3' => 'required',
            'j4' => 'required',
            'j5' => 'required',
        ]);

        if ($validator->passes()) {


        $id_user = $request->input('id_user');
        $question_1 = $request->input('j1');
        $question_2 = $request->input('j2');
        $question_3 = $request->input('j3');
        $question_4 = $request->input('j4');
        $question_5 = $request->input('j5');

        $anemiaKehamilan=array(
            'id_user'=>$id_user,
            'question_1'=>$question_1, 
            'question_2'=>$question_2, 
            'question_3'=>$question_3, 
            'question_4'=>$question_4, 
            'question_5'=>$question_5, 
        );
        DB::table('anemia_kehamilan')->insert($anemiaKehamilan);

        return response()->json(['success'=>'Data submit successfully.']); 
    }

    return response()->json(['error'=>$validator->errors()]);

    }

    public function userNavigasi(Request $request)
    {
        //
        $id_user = $request->input('id_user');        
        $id_navigasi = $request->input('id_navigasi');

        $dataNavigasi = array('id_user'=>$id_user,'id_navigasi'=>$id_navigasi);

        DB::table('user_navigasis')->insert($dataNavigasi); 

        return response()->json(['success'=>'Data submit successfully.']); 
    }

}
