@extends('layouts.admin')
@section('title_web')
Data IMT ibu Hamil - Aplikasi AFRIKOT
@endsection

@section('main-content')
    <!-- Page Heading -->
<h1 class="h3 mb-4 text-gray-800"><i class="fas fa-book-medical"></i>&nbsp; {{ $title ?? __('Blank Page') }}</h1>
<hr>

    <!-- Main Content goes here -->

    <a href="#" class="btn btn-info mb-3 font-weight-bold">Jumlah: {{ $count_user }} Ibu hamil</a>

	<a href="#" class="btn btn-info mb-3 font-weight-bold">{{ count($userCount)}}</a>

    @if (session('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    <table class="table table-bordered table-stripped">
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="30%">Nama Bunda</th>
            	<th width="10%">Tinggi Badan</th>
            	<th width="13%">BB Pra Hamil</th>
            	<th width="12%">BB Saat Hamil</th>
                <th width="10%">IMT Pra Hamil</th>
            	<th width="15%">Kondisi berdasar IMT</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data_istri as $user)
                <tr>
                    <td scope="row">{{ $loop->iteration }}</td>
                    <td>{{ $user->nama_istri }}</td>
                    <td>{{ $user->tb_istri }} CM</td>
                	<td>{{ $user->bb_belum_hamil }} KG</td>
                	<td>{{ $user->bb_saat_hamil }} KG</td>
                    <td>
                        <div class="d-flex">
                          {{ $user->imt_pra_hamil }}
                            
                        </div>
                    </td>
                
                	<td>
                        <div class="d-flex">
                        
                        @if ($user->imt_pra_hamil<=0)
            Data tidak ditemukan 
            @elseif ($user->imt_pra_hamil<=18.49)
                                                 <a href="#" class="btn btn-sm btn-dark mr-2">Kurus</a> 
        @elseif ($user->imt_pra_hamil<=24.9)
                                            <a href="#" class="btn btn-sm btn-success mr-2">Normal</a>
@elseif ($user->imt_pra_hamil<=29.9)
                                    <a href="#" class="btn btn-sm btn-warning mr-2">Overweight</a>
@else
        <a href="#" class="btn btn-sm btn-danger mr-2">Obesitas</a>
@endif
                            
                        </div>
                    </td>
                
                
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $data_istri->links() }}

    <!-- End of Main Content -->
@endsection

@push('notif')
    @if (session('success'))
        <div class="alert alert-success border-left-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('status'))
        <div class="alert alert-success border-left-success" role="alert">
            {{ session('status') }}
        </div>
    @endif
@endpush
