@extends('layouts.admin')
@section('title_web')
Data IMT ibu Hamil - Aplikasi AFRIKOT
@endsection

@section('main-content')
    <!-- Page Heading -->
<h1 class="h3 mb-4 text-gray-800"><i class="fas fa-book-medical"></i>&nbsp; {{ $title ?? __('Blank Page') }}</h1>
<hr>

    <!-- Main Content goes here -->

    <a href="#" class="btn btn-info mb-3 font-weight-bold">Jumlah: {{ $count_user }} Ibu hamil</a>

    @if (session('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    <table class="table table-bordered table-stripped">
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Bunda</th>
            	<th>Tinggi Badan</th>
            	<th>BB Sebelum Hamil</th>
            	<th>BB Saat Hamil</th>
                <th>Lingkar Lengan</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data_istri as $user)
                <tr>
                    <td scope="row">{{ $loop->iteration }}</td>
                    <td>{{ $user->nama_istri }}</td>
                    <td>{{ $user->tb_istri }} CM</td>
                	<td>{{ $user->bb_belum_hamil }} KG</td>
                	<td>{{ $user->bb_saat_hamil }} KG</td>
                    <td>
                        <div class="d-flex">
                           <a href="#" class="btn btn-sm btn-primary mr-2">{{ $user->imt_pra_hamil }}</a>
                            
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $data_istri->links() }}

    <!-- End of Main Content -->
@endsection

@push('notif')
    @if (session('success'))
        <div class="alert alert-success border-left-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('status'))
        <div class="alert alert-success border-left-success" role="alert">
            {{ session('status') }}
        </div>
    @endif
@endpush
